/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzacraft.blockentity;

import com.tiviacz.pizzacraft.blockentity.BaseBlockEntity;
import com.tiviacz.pizzacraft.blocks.PizzaBagBlock;
import com.tiviacz.pizzacraft.container.PizzaBagMenu;
import com.tiviacz.pizzacraft.init.ModBlockEntityTypes;
import com.tiviacz.pizzacraft.init.ModItems;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;

public class PizzaBagBlockEntity
extends BaseBlockEntity
implements MenuProvider {
    private final ItemStackHandler inventory = this.createHandler();
    private final LazyOptional<ItemStackHandler> inventoryCapability = LazyOptional.of(() -> this.inventory);
    private ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void m_142292_(Level level, BlockPos pos, BlockState state) {
            PizzaBagBlockEntity.this.playSound();
            PizzaBagBlockEntity.this.updateBlockState(state, true);
        }

        protected void m_142289_(Level level, BlockPos pos, BlockState state) {
            PizzaBagBlockEntity.this.playSound();
            PizzaBagBlockEntity.this.updateBlockState(state, false);
        }

        protected void m_142148_(Level level, BlockPos pos, BlockState state, int p_155069_, int p_155070_) {
        }

        protected boolean m_142718_(Player player) {
            return player.f_36096_ instanceof PizzaBagMenu;
        }
    };

    public PizzaBagBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.PIZZA_BAG.get(), pos, state);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.inventory.deserializeNBT(compound.m_128469_("Inventory"));
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
    }

    public void writeToItemStack(ItemStack stack) {
        CompoundTag compound = new CompoundTag();
        if (this.isEmpty((IItemHandlerModifiable)this.inventory)) {
            return;
        }
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        stack.m_41751_(compound);
    }

    public void readFromStack(ItemStack stack) {
        if (stack.m_41783_() != null) {
            this.inventory.deserializeNBT(stack.m_41783_().m_128469_("Inventory"));
        }
    }

    public void startOpen(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155452_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void stopOpen(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155468_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void recheckOpen() {
        if (!this.f_58859_) {
            this.openersCounter.m_155476_(this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    private void updateBlockState(BlockState state, boolean bol) {
        this.f_58857_.m_7731_(this.m_58899_(), (BlockState)state.m_61124_((Property)PizzaBagBlock.PROPERTY_OPEN, (Comparable)Boolean.valueOf(bol)), 3);
    }

    private void playSound() {
        double d0 = (double)this.m_58899_().m_123341_() + 0.5;
        double d1 = (double)this.m_58899_().m_123342_() + 0.5;
        double d2 = (double)this.m_58899_().m_123343_() + 0.5;
        this.f_58857_.m_6263_(null, d0, d1, d2, SoundEvents.f_12642_, SoundSource.BLOCKS, 0.5f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 0.9f);
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(6){

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return stack.m_41720_() == ModItems.PIZZA.get() || stack.m_41720_() == ModItems.RAW_PIZZA.get();
            }

            protected void onContentsChanged(int slot) {
                PizzaBagBlockEntity.this.m_6596_();
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public IItemHandlerModifiable getInventory() {
        return this.inventory;
    }

    public Component m_5446_() {
        return Component.m_237115_((String)this.m_58900_().m_60734_().m_7705_());
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player player) {
        return new PizzaBagMenu(id, playerInventory, this);
    }

    public void openGUI(Player player, MenuProvider containerSupplier, BlockPos pos) {
        if (!player.f_19853_.f_46443_) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)containerSupplier, (BlockPos)pos);
        }
    }
}

